
******************************************************************
*
* PANEL-ANALYSIS (using an artificial dataset)
*
* JOSEF BRDERL, UNIVERSITY OF MUNICH, November 2012
*
******************************************************************

* This DO-File contains the STATA commands for the
* FE Logit example

* These are the variables in the dataset:
* id    person identifier
* time  # panel wave
* feduc participating in further education
* wage  monthly wage in Euro


* The further variables are used for other problems


* Load the dataset (adapt the path)
global pfad1 `""K:\Vorlesung Lngsschnitt\Material PDA\Stata Beispiele\""'
cd $pfad1
use "Wage Premium.dta", clear

* First one has to "xtset" the data
* "id" is the person number, "time" is the time variable
xtset id time


********************************************
* FE (Conditional) Logit
* depvar: further education, indepvar: wage
* high-wage people have a higher risk of feduc (self-selection)
********************************************
* Plotting the data
# delimit ;
twoway
   (scatter wage time, ylabel(0(1000)5000, grid) ymtick(500(1000)4500, grid) c(L))
   (scatter wage time if feduc==1),
    legend(label(1 "no further education") label(2 "further education"));
* Number of Persons with all Y=1 or Y=0
by id: gen      mfeduc = sum(feduc)/sum(feduc~=.)
by id: replace  mfeduc = .  if _n < _N
tab             mfeduc

* Rescaling the wage
replace wage = wage/1000

* Pooled-Logit
logit feduc wage

* Conditional-Logit
xtlogit feduc wage, fe

* Linear Probability model as alternative
xtreg feduc wage, fe


